define(['HealthMoodEntryController', 'HealthMoodConstants', 'moment'], function() {
	'use strict';

	describe("The Health Entry Controller - Edit", function (){
		var q,
			controller,
			scope,
			stateParams,
			state,
			deferredReminder,
			serviceMock,
			remindersServiceMock,
			focusServiceMock,
			modalServiceMock,
			localGetByIdSpy,
			section = "glucose",
			sectionName = "Edit " + section + " Entry",
			itemId = "item_id",
			localGetByIdReturn = { id: itemId },
			allowedActionsMock = {
				save : true,
				delete : true,
				cancel : true
			};

		beforeEach(function() {
			module('angularTemplateApp');

			serviceMock = jasmine.createSpyObj('HealthMoodService', ['instance']);
			remindersServiceMock = jasmine.createSpyObj('HealthMoodRemindersService', ['init', 'getReminder']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);
			modalServiceMock = jasmine.createSpyObj('modalService', ['showModal']);
			localGetByIdSpy = jasmine.createSpy("localGetByIdSpy").and.returnValue(localGetByIdReturn);

			module(function($provide){
				$provide.value('HealthMoodService', serviceMock);
				$provide.value('HealthMoodRemindersService', remindersServiceMock);
				$provide.value('focusService', focusServiceMock);
				$provide.value('modalService', modalServiceMock);
			});

			inject(function($controller, $rootScope, $stateParams, $state, $q) {
				scope = $rootScope.$new();
				state = $state;
				q = $q;

				serviceMock.instance.and.returnValue({
					localGetById: localGetByIdSpy
				});

				stateParams = {
					section: section,
					id: itemId
				};

				state.current.data = {
					backState: "parentState",
					paramSections: [{
						paramValue: section,
						sectionName: sectionName
					}]
				};

				deferredReminder = q.defer();
				remindersServiceMock.getReminder.and.returnValue(deferredReminder.promise);

				controller = $controller('HealthMoodEntryController', { $scope: scope, $state: state, $stateParams: stateParams });
			});
		});

		describe("when the page is loaded", function() {
			it("scope variables should be defined and correct", function() {
				deferredReminder.resolve('resolved');
				scope.$apply();

				var detailsMock = angular.copy(localGetByIdReturn);
				expect(scope.section).toBe(section);
				expect(scope.entryForm.service).toEqual(serviceMock.instance());
				expect(scope.entryForm.callbacks.common).toBeDefined();
				expect(scope.entryForm.allowedActions).toEqual(allowedActionsMock);
				expect(scope.sectionTitle).toBe(sectionName);
				expect(scope.entryInputsTemplate).toBe("src/modules/health-mood/pages/entry/partials/_glucose.html");
				expect(scope.details).toEqual(detailsMock);
				expect(localGetByIdSpy).toHaveBeenCalledWith(itemId);
				expect(scope.allowedDateRange).toEqual({min: moment().subtract(6, 'year').format('L')});
				expect(scope.notificationDetails).toEqual('resolved');
			});

			it("scope functions should be correct", function () {
				spyOn(state, 'go');
				scope.entryForm.callbacks.common();
				expect(state.go).toHaveBeenCalledWith('parentState', { section : 'glucose', id : 'item_id' });
			});
		});
	});

	describe("The Health Entry Controller - Add", function (){
		var controller,
			scope,
			stateParams,
			state,
			serviceMock,
			remindersServiceMock,
			focusServiceMock,
			modalServiceMock,
			createEmptySpy,
			section = "glucose",
			sectionName = "Add " + section + " Entry",
			stateName = "State Name",
			createEmptyReturn = {};

		beforeEach(function() {
			module('angularTemplateApp');

			serviceMock = jasmine.createSpyObj('HealthMoodService', ['instance']);
			remindersServiceMock = jasmine.createSpyObj('HealthMoodRemindersService', ['init', 'getReminder']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);
			modalServiceMock = jasmine.createSpyObj('modalService', ['showModal']);
			createEmptySpy = jasmine.createSpy("createEmptySpy").and.returnValue(createEmptyReturn);
			remindersServiceMock.getReminder.and.returnValue({then: function () {}});

			module(function($provide){
				$provide.value('HealthMoodService', serviceMock);
				$provide.value('HealthMoodRemindersService', remindersServiceMock);
				$provide.value('focusService', focusServiceMock);
				$provide.value('modalService', modalServiceMock);
			});

			inject(function($controller, $rootScope, $stateParams, $state) {
				scope = $rootScope.$new();
				state = $state;

				serviceMock.instance.and.returnValue({
					createEmpty: createEmptySpy
				});

				stateParams = {
					section: section
				};

				state.current.data = {
					paramSections: [{
						paramValue: section,
						sectionName: sectionName
					}]
				};

				state.current.name = stateName;

				controller = $controller('HealthMoodEntryController', { $scope: scope, $state: state, $stateParams: stateParams });
			});
		});

		describe("when the page is loaded", function() {
			it("scope variables should be defined and correct", function() {
				expect(scope.section).toBe(section);
				expect(scope.entryForm.service).toEqual(serviceMock.instance());
				expect(scope.entryForm.callbacks.common).toBeDefined();
				expect(scope.entryForm.allowedActions).toEqual({
					save : true,
					delete : false,
					cancel : true
				});
				expect(scope.sectionTitle).toBe(sectionName);
				expect(scope.entryInputsTemplate).toBe("src/modules/health-mood/pages/entry/partials/_glucose.html");
				expect(scope.details).toEqual(createEmptyReturn);
				expect(createEmptySpy).toHaveBeenCalled();
			});
		});
	});

	describe("The Health Entry Controller - Mood-specific logic", function (){
		var q,
			controller,
			scope,
			stateParams,
			state,
			serviceMock,
			remindersServiceMock,
			focusServiceMock,
			modalServiceMock,
			localGetByIdSpy,
			section = "mood",
			sectionName = "Edit " + section + " Entry",
			itemId = "item_id",
			localGetByIdReturn = { id: itemId };

		beforeEach(function() {
			module('angularTemplateApp');

			serviceMock = jasmine.createSpyObj('HealthMoodService', ['instance']);
			remindersServiceMock = jasmine.createSpyObj('HealthMoodRemindersService', ['init', 'getReminder']);
			focusServiceMock = jasmine.createSpyObj('focusService', ['focusElement']);
			modalServiceMock = jasmine.createSpyObj('modalService', ['showModal']);
			localGetByIdSpy = jasmine.createSpy("localGetByIdSpy").and.returnValue(localGetByIdReturn);
			remindersServiceMock.getReminder.and.returnValue({then: function () {}});

			module(function($provide){
				$provide.value('HealthMoodService', serviceMock);
				$provide.value('HealthMoodRemindersService', remindersServiceMock);
				$provide.value('focusService', focusServiceMock);
				$provide.value('modalService', modalServiceMock);
			});

			inject(function($controller, $rootScope, $stateParams, $state, $q) {
				scope = $rootScope.$new();
				state = $state;
				q = $q;

				serviceMock.instance.and.returnValue({
					localGetById: localGetByIdSpy
				});

				stateParams = {
					section: section,
					id: itemId
				};

				state.current.data = {
					backState: "parentState",
					paramSections: [{
						paramValue: section,
						sectionName: sectionName
					}]
				};

				controller = $controller('HealthMoodEntryController', { $scope: scope, $state: state, $stateParams: stateParams });

				scope.details = {
					valueQuantity: {
						value: null
					}
				};
			});
		});

		describe("when the page is loaded", function() {
			it("scope variables should be defined and correct", function () {
				expect(scope.errorHandling).toEqual({
					'requiredMood': {
						message: "Mood field is required.",
						priority: 1
					}
				});
			});
		});

		describe("when the mood modal is used", function() {
			beforeEach( function () {
				scope.form = {
					$setDirty: function () {}
				};
				spyOn(scope.form, '$setDirty');

				var deferred = q.defer();
				deferred.resolve('resolvedPromise');
				modalServiceMock.showModal.and.returnValue(deferred.promise);
				scope.openMoodModal();

			});

			it("should set the new value and refocus on the button", function () {
				expect(scope.details.valueQuantity.value).toBeNull();

				scope.$apply();
				expect(modalServiceMock.showModal).toHaveBeenCalled();
				expect(scope.details.valueQuantity.value).toEqual(5);
				expect(scope.form.$setDirty).toHaveBeenCalled();
				expect(focusServiceMock.focusElement).toHaveBeenCalled();
			});
		});

		describe("when the mood rating changes", function() {
			it("should run required field validation", function () {
				var specialErrors = {
					$setValidity: function () {}
				};
				spyOn(specialErrors, '$setValidity');

				scope.$digest();
				expect(specialErrors.$setValidity).not.toHaveBeenCalled();

				scope.details.valueQuantity.value = 3;
				scope.form = {
					specialErrors: specialErrors
				};

				scope.$digest();
				expect(specialErrors.$setValidity).toHaveBeenCalled();
			});
		});
	});
});